(function(win, doc) {
  const $ = s => doc.querySelector(s)
  const addEvent = (n, e, h) => {
    n.addEventListener(e, h, false)
  }

  const changeFilters = () => {
    target.style['webkit' + 'Filter'] = 'brightness(' + filtersMap['brightness'] + ')'
  }

  const setFilters = (key, value) => {
    if (!filtersMap) {return}
    filtersMap[key] = value
    changeFilters()
  }

  let filtersMap = {
    hue: '0deg',
    brightness: 1
  }
  let tempCover = document.querySelector('.img__cover')

  let s = $('[name="light-switch"]')
  let b = $('[name="brightness"]')
  let t = $('[name="temp"]')

  let target = $('.img')

  // turn light on and off
  addEvent(s, "change", (e) => {
    target.classList.toggle('img--on')
  })

  // 控制冷暖色调遮罩
  addEvent(t, 'input', (e) => {
    let $val = parseInt(e.target.value)
    if ($val > 0) {
      tempCover.style.background = 'rgba(255,255,0,' + Math.abs($val) / 400 + ')'
    } else {
      tempCover.style.background = 'rgba(0, 0, 255,' + Math.abs($val) / 400 + ')'
    }
  })

  addEvent(b, 'input', (e) => {
    let $val = parseInt(e.target.value)
    let $brightness = $val / 100
    setFilters('brightness', $brightness)
  })

})(window, document)