// Letters
const letters = ["A", "B", "C", "D", "E", "F"];
// Numbers
const numbers = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9];

// Generate button
const btnGen = document.getElementById("btn-gen");
// Body element: used to change background-color
const backgroundDoc = document.body;
// Hex color: it'll be shown on the web
const hexText = document.getElementById("color-hex");

// This variable will store the generated color
let hexColor = "";

// Function that adds a random letter to the generated color
function addLetter() {
  hexColor += letters[Math.floor(Math.random() * letters.length)];
}
// Function that adds a random number to the generated color
function addNumber() {
  hexColor += numbers[Math.floor(Math.random() * numbers.length)];
}
// Function that generates the color
function generateColor() {
  hexColor = ""; // when function is called, this variable will be empty

  for (let i = 0; i <= 5; i++) {
    // The program makes a choice based on a randomly generated number
    const choice = Math.floor(Math.random() * 2);

    // If the generated number is 0, then it will add a letter to the hex code
    if (choice == 0) {
      addLetter();
    } else if (choice == 1) {
      // if it's 1, it will add a number
      addNumber();
    }
  }
  return hexColor;
}

// Event triggered when the 'Generate' button is clicked on
btnGen.addEventListener("click", function () {
  let generatedColor = generateColor(); // the generateColor() function is called and we use its returned value
  backgroundDoc.style.backgroundColor = "#" + generatedColor; // assign the generated color as the body's background-color
  hexText.innerText = "#" + generatedColor; // shows the hex code on the website
});