!function() {
  function dataURLtoBlob(dataURL, type) {
    var binary = atob(dataURL.split(',')[1]),
        length = binary.length,
        binaryArray = new Uint8Array(length);
    for (var i = 0; i < length; i++) {
      binaryArray[i] = binary.charCodeAt(i);
    }
    return new Blob([binaryArray], {type: type});
  }

  var SolidImage = function() {
    var canvas = document.createElement('canvas'),
        ctx = canvas.getContext('2d');
    this.img = new Image();
    this.make = function(width, height, color) {
      canvas.width = width;
      canvas.height = height;
      ctx.fillStyle = color;
      ctx.fillRect(0, 0, canvas.width, canvas.height);
      var dataURL = canvas.toDataURL('image/png')
      this.img.src = dataURL;
      if (this.blobURL) URL.revokeObjectURL(this.blobURL);
      this.blob = dataURLtoBlob(dataURL, 'image/png');
      this.blobURL = URL.createObjectURL(this.blob);
    }
  };
  
  var solidImage = new SolidImage(),
      width = screen.width,
      height = screen.height,
      input = document.getElementById('color'),
      button = document.getElementById('make'),
      result = document.getElementById('result'),
      link = document.createElement('a');
  
  link.setAttribute('target', '_blank');
  result.appendChild(solidImage.img);
  result.insertAdjacentHTML('beforeend', 'Save this image or<br>');
  result.appendChild(link);
  solidImage.img.width = 600;


  button.addEventListener('click', function(){
    var filename = width + 'x' + height + input.value + '.png';
    solidImage.make(width, height, input.value);
    link.innerHTML = 'Download ' + filename;
    link.setAttribute('href', solidImage.blobURL);
    link.setAttribute('download', filename);
    result.className = 'generated';
  });
}();