const gradientPreview = document.querySelector(".gradient-preview");
const gradientTypeSelect = document.querySelector("#gradient-type");
const directionSelect = document.querySelector("#direction");
const colorInputs = document.querySelectorAll("input[type='color']");
const opacityInputs = document.querySelectorAll("input[type='range']");
const cssOutput = document.querySelector("#css-output");
const refreshButton = document.querySelector("#refresh");
const copyButton = document.querySelector("#copy");

// Generate random hex color
const getRandomColor = () =>
  `#${Math.floor(Math.random() * 0xffffff).toString(16).padStart(6, "0")}`;

// Update gradient preview and CSS output
const updateGradient = () => {
  const gradientType = gradientTypeSelect.value;
  const direction = directionSelect.value;
  const color1 = hexToRgba(colorInputs[0].value, opacityInputs[0].value);
  const color2 = hexToRgba(colorInputs[1].value, opacityInputs[1].value);

  let gradient;
  if (gradientType === "linear") {
    gradient = `linear-gradient(${direction}, ${color1}, ${color2})`;
  } else {
    gradient = `radial-gradient(circle, ${color1}, ${color2})`;
  }

  gradientPreview.style.background = gradient;
  cssOutput.value = `background: ${gradient};`;
};

// Convert hex color to rgba
const hexToRgba = (hex, opacity) => {
  const bigint = parseInt(hex.slice(1), 16);
  const r = (bigint >> 16) & 255;
  const g = (bigint >> 8) & 255;
  const b = bigint & 255;
  return `rgba(${r}, ${g}, ${b}, ${opacity})`;
};

// Generate random colors and update gradient
const randomizeColors = () => {
  colorInputs[0].value = getRandomColor();
  colorInputs[1].value = getRandomColor();
  opacityInputs[0].value = Math.random().toFixed(2);
  opacityInputs[1].value = Math.random().toFixed(2);
  updateGradient();
};

// Copy CSS code to clipboard
const copyToClipboard = () => {
  navigator.clipboard.writeText(cssOutput.value);
  copyButton.textContent = "Copied!";
  setTimeout(() => (copyButton.textContent = "Copy Code"), 1500);
};

// Event listeners
colorInputs.forEach((input) => input.addEventListener("input", updateGradient));
opacityInputs.forEach((input) => input.addEventListener("input", updateGradient));
gradientTypeSelect.addEventListener("change", updateGradient);
directionSelect.addEventListener("change", updateGradient);
refreshButton.addEventListener("click", randomizeColors);
copyButton.addEventListener("click", copyToClipboard);

// Initialize gradient
updateGradient();
